<?php

class ControllerModulesmslink extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('module/smslink');
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate())
        {
            $this->model_setting_setting->editSetting('smslink', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $text_strings = array(
            'heading_title',
            'text_smslink_balance',
            'text_contact_example',
            'text_send_sms',
            'text_admin_alert_customer_checkout',
            'button_save',
            'button_cancel',
            'button_send_sms',
            'entry_smslink_balance',
            'entry_smslink_admin_contact',
            'entry_smslink_username',
            'entry_smslink_password',
            'entry_smslink_admin_alert',
            'order_enabled',
            'order_message',
            'notify_admin',
            'admin_telephone',
        );

        foreach ($text_strings as $text)
            $this->data[$text] = $this->language->get($text);

        $config_data = array(
            'smslink_username',
            'smslink_password',
            'notify_admin_value',
            'admin_telephone_value',
            'smslink_admin_alert_customer_checkout',
            'order_message_value',
            'order_enabled_value',
        );

        $this->load->model('localisation/order_status');
        $statuses = new ModelLocalisationOrderStatus($this->registry);
        $statuses = $statuses->getOrderStatuses();
        $this->data['statuses'] = $statuses;

        foreach ($statuses as $key => $status)
        {
            $config_data[] = 'message_of_order_status_'.$status["order_status_id"];
            $config_data[] = 'order_status_'.$status["order_status_id"].'_enabled';
        }

        foreach ($config_data as $conf) {
            if (isset($this->request->post[$conf])) {
                $this->data[$conf] = $this->request->post[$conf];
            } else {
                $this->data[$conf] = $this->config->get($conf);
            }
        }

        if($this->data['smslink_username'] == "" || $this->data['smslink_password'] == "")
        {
            $this->data['smslink_balance'] = $this->data['text_smslink_balance'];
        }
        else
        {
            require_once(DIR_SYSTEM . 'library/smslink.php');
            $smslink = new smslink;
            $smslink->setApi($this->data['smslink_username'], $this->data['smslink_password']);
            $this->data['smslink_balance'] = $smslink->smslink_balance();
        }

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_home'),
            'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => false
        );

        $this->data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_module'),
            'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $this->data['breadcrumbs'][] = array(
            'text'      => $this->language->get('heading_title'),
            'href'      => $this->url->link('module/smslink', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $this->data['action'] = $this->url->link('module/smslink', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');        
        $this->data['send_sms'] = $this->url->link('module/smslink', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['modules'] = array();

        if (isset($this->request->post['smslink_module'])) {
            $this->data['modules'] = $this->request->post['smslink_module'];
        } elseif ($this->config->get('smslink_module')) {
            $this->data['modules'] = $this->config->get('smslink_module');
        }

        $this->load->model('design/layout');

        $this->data['layouts'] = $this->model_design_layout->getLayouts();

        $this->template = 'module/smslink.tpl';
        $this->children = array(
            'common/header',
            'common/footer',
        );

        $this->response->setOutput($this->render());

    }

    public function install()
    {

    }

    public function uninstall()
    {

    }

    private function validate()
    {
        if (!$this->user->hasPermission('modify', 'module/smslink'))
        {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->error)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }

    }

    public function verify_api()
    {
        require_once(DIR_SYSTEM . 'library/smslink.php');
        $smslink = new smslink;

        $username = $_REQUEST['user'];
        $password = $_REQUEST['pass'];

        if ((strlen($username) > 0) and (strlen($username) > 0))
        {
            $response = $smslink->smslink_balance($username, $password, 1);

            echo "Numarul de SMS-uri disponibile in contul dvs. de utilizator: ".$response;
        }
        else
        {
            echo "Introduceti Connection ID si Parola asociate serviciului SMS Gateway din contul dvs. SMSLink.";

        }

    }

}
?>