<?php

class SMSLinkLog extends ModuleAdminController
{
    public function __construct()
    {
        $this->table = 'smslink_log';
        $this->identifier = 'id';
        $this->bootstrap = true;
        $this->list_simple_header = false;
        $this->display = 'list';
        $this->meta_title = 'Istoric si Cautare SMS';
        $this->colorOnBackground = false;
        $this->actions = array();
        
        $this->no_link = true;
        $this->context = Context::getContext();

        $this->list_no_link = true;

        $this->token = Tools::getAdminTokenLite('AdminModules');

        @$this->currentIndex = AdminController::$currentIndex;
        
        $this->_defaultOrderBy = 'id';
        $this->_defaultOrderWay = 'DESC';

        $this->fields_list = array(
            'id' => array(
                'title'           => 'ID',
                'width'           => 20,
                'type'            => 'text',
                'search'          => false,
                'orderby'         => true,
                'align'           => 'left'
            ),
            'receiver' => array(
                'title'           => 'Telefon',
                'width'           => 150,
                'type'            => 'text',
                'search'          => true,
                'orderby'         => false,
                'align'           => 'left'
            ),
            'message' => array(
                'title'           => 'Mesaj (Lungime)',
                'width'           => 400,
                'type'            => 'text',
                'callback'        => 'message',

                'callback_object' => $this,
                'search'          => false,
                'orderby'         => false,
                'align'           => 'left'               

            ),
            'timestamp_queued' => array(
                'title'           => 'Data / Ora<br />(locala)',
                'width'           => 150,
                'type'            => 'datetime',
                'search'          => true,
                'orderby'         => true,
                'align'           => 'left'
            ),            
            'remote_status' => array(
                'title'           => 'Stare transmitere',
                'width'           => 100,
                'type'            => 'text',
                'callback'        => 'status',
                'callback_object' => $this,     
                'search'          => false,
                'orderby'         => true,
                'align'           => 'left',
                'hint'            => 'Starea transmiterii SMS-ului catre SMSLink'
            ),
            'remote_response' => array(
                'title'           => 'Log transmitere',
                'width'           => 200,
                'type'            => 'text',
                'callback'        => 'details',
                'callback_object' => $this,
                'search'          => false,
                'orderby'         => false,
                'align'           => 'left',
                'hint'            => 'Log-ul transmiterii SMS-ului catre SMSLink'
            ),
            'remote_message_id' => array(
                'title'           => 'Detalii SMSLink',
                'width'           => 100,
                'type'            => 'text',
                'callback'        => 'link',
                'callback_object' => $this,
                'search'          => false,
                'orderby'         => false,
                'align'           => 'left',
                'hint'            => 'Informatii referitoare la livrarea SMS-ului catre destinatar'

            )

        );

        parent::__construct();
        
    }

    public function status($status)
    {
        switch ($status)
        {
            case 1: 
                return "Transmis catre SMSLink";
                break;    
            case 2: 
                return "Eroare returnata de SMSLink";
                break;
            case 3:
                return "Eroare conexiune";
                break;
            default:
                return "-";
                break;
        }
        
    }
    
    public function link($remote_message_id)
    {
        if (($remote_message_id > 0) and (strlen($remote_message_id) > 0)) return '<a href="http://www.smslink.ro/sms/history-sent.php?message_id='.$remote_message_id.'" target="_blank">Deschide</a>';
            else return '-';
            
    }
        
    public function details($remote_response)
    {
        $ElementTempID = rand(1000000, 9999999);
        
        if (strlen($remote_response) > 0)
        { 
            return '<a href="#Details" onclick="document.getElementById(\'Details'.$ElementTempID.'\').innerHTML = \''.addslashes($remote_response).'\';" style="text-decoration: ;">(+) Detalii</a> <div id="Details'.$ElementTempID.'" name="Details'.$ElementTempID.'"></div>';
        }
        else 
        {
            return '-';           
        }         

    }
    
    public function message($message)
    {
        return $message." (".strlen($message)." caractere)";
            
    }
    
    public function initPageHeaderToolbar()
    {
        $this->page_header_toolbar_title = 'Istoric si Cautare SMS';
        
        parent::initPageHeaderToolbar();
        unset($this->toolbar_btn['new']);        
        
    }
    
}
