<?php

class SMSLinkTestSettingsController extends ModuleAdminController
{
    protected $index;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->meta_title = 'Testare Configuratie';
        $this->display = 'add';

        $this->context = Context::getContext();
        $this->token = Tools::getAdminTokenLite('AdminModules');

        parent::__construct();

        $this->index = count($this->_conf) + 1;
        $this->_conf[$this->index] = 'Mesajul a fost transmis cu succes.';
    }

    public function renderForm()
    {
        $connectionId = (string) Configuration::get('SMSLINK_CONNECTION_ID');
        $password     = (string) Configuration::get('SMSLINK_PASSWORD');

        $configured = !(empty($connectionId) || empty($password));

        $testStatus = (int) Configuration::get('SMSLINK_TEST');
        $testPhone  = $this->module->Phone(Configuration::get('SMSLINK_TEST_PHONE'));

        $configUrl = $this->context->link->getAdminLink('AdminModules', true, [], [
            'configure' => 'smslink',
        ]);

        $this->fields_form = [
            'legend' => [
                'title' => 'Transmite un SMS pentru testarea setarilor cu SMSLink',
            ],
            'input' => [
                [
                    'type' => 'text',
                    'label' => 'Numar de telefon',
                    'name' => 'Phone',
                    'required' => true,
                    'desc' =>
                        ($testStatus == 1
                            ? "<strong>Important!</strong> Modul test este activ. SMS-urile vor fi trimise la {$testPhone}. <a href='{$configUrl}'>Configurare</a><br>"
                            : ''
                        ) .
                        (!$configured
                            ? "<strong>Atentie!</strong> Modulul nu este configurat. <a href='{$configUrl}'>Configurare</a>"
                            : ''
                        ),
                ],
                [
                    'type' => 'textarea',
                    'rows' => 2,
                    'label' => 'Text SMS',
                    'name' => 'Message',
                    'required' => true,
                    'desc' => '<b>Stare conexiune:</b><br>' . $this->module->Credit(1),
                ],
            ],
            'submit' => [
                'title' => 'Trimite',
            ],
        ];

        $this->fields_value['Phone']   = $testPhone ?: '0723123456';
        $this->fields_value['Message'] = 'Acesta este un SMS de test transmis de pe ' . Configuration::get('PS_SHOP_NAME');

        $this->context->controller->addJS(
            _MODULE_DIR_ . $this->module->name . '/functions.js'
        );

        return parent::renderForm();
    }

    public function postProcess()
    {
        if (Tools::isSubmit('submitAdd' . $this->table)) {
            $connectionId = (string) Configuration::get('SMSLINK_CONNECTION_ID');
            $password     = (string) Configuration::get('SMSLINK_PASSWORD');

            if (empty($connectionId) || empty($password)) {
                $this->errors[] = $this->trans(
                    'Pentru test este necesara configurarea modulului.',
                    [],
                    'Modules.Smslink.Admin'
                );
                return;
            }

            $phone   = (string) Tools::getValue('Phone');
            $message = (string) Tools::getValue('Message');

            if ($phone && $message) {
                $this->module->QueueSMS($phone, $message, 1);

                Tools::redirectAdmin(
                    self::$currentIndex . '&conf=' . $this->index . '&token=' . $this->token
                );
            } else {
                $this->errors[] = $this->trans(
                    'Numarul de telefon si mesajul sunt obligatorii.',
                    [],
                    'Modules.Smslink.Admin'
                );
            }
        }
    }

    public function initPageHeaderToolbar()
    {
        $this->page_header_toolbar_title = 'Transmite un SMS pentru testarea setarilor cu SMSLink';
        parent::initPageHeaderToolbar();
    }
}
