<?php

class SMSLinkLogController extends ModuleAdminController
{
    public function __construct()
    {
        $this->table = 'smslink_log';
        $this->identifier = 'id';
        $this->bootstrap = true;
        $this->list_simple_header = false;
        $this->display = 'list';
        $this->meta_title = 'Istoric si Cautare SMS';
        $this->colorOnBackground = false;
        $this->actions = [];

        $this->no_link = true;
        $this->list_no_link = true;

        $this->_defaultOrderBy = 'id';
        $this->_defaultOrderWay = 'DESC';

        $this->fields_list = [
            'id' => [
                'title' => 'ID',
                'width' => 20,
                'type' => 'text',
                'search' => false,
                'orderby' => true,
            ],
            'receiver' => [
                'title' => 'Telefon',
                'width' => 150,
                'type' => 'text',
                'search' => true,
            ],
            'message' => [
                'title' => 'Mesaj (Lungime)',
                'width' => 400,
                'type' => 'text',
                'callback' => 'message',
                'callback_object' => $this,
            ],
            'timestamp_queued' => [
                'title' => 'Data / Ora<br />(locala)',
                'type' => 'datetime',
                'search' => true,
                'orderby' => true,
            ],
            'remote_status' => [
                'title' => 'Stare transmitere',
                'type' => 'text',
                'callback' => 'status',
                'callback_object' => $this,
            ],
            'remote_response' => [
                'title' => 'Log transmitere',
                'type' => 'text',
                'callback' => 'details',
                'callback_object' => $this,
            ],
            'remote_message_id' => [
                'title' => 'Detalii SMSLink',
                'type' => 'text',
                'callback' => 'link',
                'callback_object' => $this,
            ],
        ];

        parent::__construct();

        // ✅ Token corect pentru controllerul curent
        $this->token = Tools::getAdminTokenLite($this->controller_name);
    }

    public function status($status)
    {
        return match ((int)$status) {
            1 => 'Transmis catre SMSLink',
            2 => 'Eroare returnata de SMSLink',
            3 => 'Eroare conexiune',
            default => '-',
        };
    }

    public function link($remote_message_id)
    {
        if (!empty($remote_message_id)) {
            return '<a href="https://www.smslink.ro/sms/history-sent.php?message_id='
                . (int)$remote_message_id . '" target="_blank">Deschide</a>';
        }
        return '-';
    }

    public function details($remote_response)
    {
        if (empty($remote_response)) {
            return '-';
        }

        $id = uniqid('details_', true);

        return sprintf(
            '<a href="#" onclick="document.getElementById(\'%s\').innerHTML = %s; return false;">(+) Detalii</a>
             <div id="%s"></div>',
            $id,
            json_encode($remote_response),
            $id
        );
    }

    public function message($message)
    {
        return $message . ' (' . Tools::strlen($message) . ' caractere)';
    }

    public function initPageHeaderToolbar()
    {
        $this->page_header_toolbar_title = 'Istoric si Cautare SMS';
        parent::initPageHeaderToolbar();
        unset($this->toolbar_btn['new']);
    }
}
