<?php

use Tygh\Registry;
require_once (Registry::get('config.dir.addons') ."smslink/api/smslink.php");

if (!defined('BOOTSTRAP'))
{
    die('Access denied');
}

ini_set('auto_detect_line_endings', true);

if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    if ($mode == 'send') 
    {
        $replaceLimit = 1;        
        $phone = str_replace("+", "00", $_POST['phone'], $replaceLimit);
        $phone = preg_replace("/[^0-9]/", "", $phone);
        
        $message = $_POST['message'];
                
        if (strlen($message) > 0)
        {
            if (strlen($phone) > 0)
            {
                foreach($orderVariabiles as $key => $value)
                    $message = str_replace($key, $value, $message);
        
                if ((strlen(Registry::get('addons.smslink.smslink-connection-id')) > 0) and (strlen(Registry::get('addons.smslink.smslink-password')) > 0))
                {
                    $SMSLinkSMSGateway = new SMSLinkSMSGateway(
                            trim(Registry::get('addons.smslink.smslink-connection-id')),
                            trim(Registry::get('addons.smslink.smslink-password'))
                        );
                    
                    $messageId = $SMSLinkSMSGateway->sendMessage($phone, $message);
                    
                    $historyLog = array(
                            'remote_message_id' => $messageId,
                            'datetime'          => date('Y-m-d H:i:s', time()),
                            'phone'             => $phone,
                            'message'           => $message,
                            'result'            => $SMSLinkSMSGateway->getLastLogMessage(),
                        );
                    
                    db_query('INSERT INTO ?:smslink_history ?e', $historyLog);
                    
                    if ($messageId !== false)
                    {
                        if($_SESSION['auth']['user_type'] === 'A')
                            fn_set_notification('N', "SMSLink", "Message succesfuly sent.", 'K');
                    }
                    else
                    {
                        if($_SESSION['auth']['user_type'] === 'A')
                            fn_set_notification('W', "SMSLink", "Error occured when sending SMS (".$SMSLinkSMSGateway->getLastLogMessage().").", 'K');
                    }
                    
                }
                else
                {
                    $historyLog = array(
                            'remote_message_id' => 0,
                            'datetime'          => date('Y-m-d H:i:s', time()),
                            'phone'             => $phone,
                            'message'           => $message,
                            'result'            => 'Connection ID or Password is blank. Please configure SMSLink addon.',
                        );
        
                    db_query('INSERT INTO ?:smslink_history ?e', $historyLog);
        
                    if ($_SESSION['auth']['user_type'] === 'A')
                        fn_set_notification('W', "SMSLink", "Unable to connect to SMSLink, Connection ID or Password is blank. Please configure SMSLink addon.", 'K');
                    
                }                 
                
            }
            else
            {
                $historyLog = array(
                        'remote_message_id' => 0,
                        'datetime'          => date('Y-m-d H:i:s', time()),
                        'phone'             => $phone,
                        'message'           => $message,
                        'result'            => 'Unable to send SMS. Phone number is blank for this order.',
                    );
        
                db_query('INSERT INTO ?:smslink_history ?e', $historyLog);
        
                if ($_SESSION['auth']['user_type'] === 'A')
                    fn_set_notification('W', "SMSLink", "Unable to send SMS. Phone number is blank for this order.", 'K');
            }
        
        }
        else
        {
            $historyLog = array(
                    'remote_message_id' => 0,
                    'datetime'          => date('Y-m-d H:i:s', time()),
                    'phone'             => $phone,
                    'message'           => $message,
                    'result'            => 'Unable to send SMS. Message cannot be left blank.',
                );
        
            db_query('INSERT INTO ?:smslink_history ?e', $historyLog);
        
            if ($_SESSION['auth']['user_type'] === 'A')
                fn_set_notification('W', "SMSLink", "Unable to send SMS. Message cannot be left blank.", 'K');
        
        }
        
    }
    
}
